varying vec2 		texcoord,
					alphacoord;

uniform sampler2D 	dif0,
					bmp0;
uniform vec2		fresnel0,
					spec0;
uniform vec4		dcolor0,
					scolor0;
uniform vec2		dscale0,
					bscale0;
uniform float 		scatterlevel;
//uniform float 		alphalevel;
uniform vec2		dofs0,
					bofs0;
uniform vec4 		colorMod;	// a = decal life
varying float		fadeAlpha;
				
/*varying vec3		eye0,
					eye1,
					eye2;*/
varying mat3		TBN;
					
#ifdef LAYER1
	uniform sampler2D 	lmask;
	uniform sampler2D 	dif1,
						bmp1;
	uniform vec2		fresnel1,
						spec1;
	uniform vec4		dcolor1,
						scolor1;
	uniform vec2		dscale1,
						bscale1;
	uniform vec2		dofs1,
						bofs1;
	#ifdef LAYER2
		uniform sampler2D 	dif2,
							bmp2;
		uniform vec2		fresnel2,
							spec2;
		uniform vec4		dcolor2,
							scolor2;
		uniform vec2		dscale2,
							bscale2;	
		uniform vec2		dofs2,
							bofs2;							
							
		#ifdef LAYER3
			uniform sampler2D 	dif3,
								bmp3;
			uniform vec2		fresnel3,
								spec3;
			uniform vec4		dcolor3,
								scolor3;
			uniform vec2		dscale3,
								bscale3;
			uniform vec2		dofs3,
								bofs3;
		#endif

	#endif

#endif

vec2 encode (vec3 n)
{
	n=normalize(n);
    float f = sqrt(8.0*n.z+8.0);
    return n.xy / f + 0.5;
}

void main()
{

	vec4 	fdcolor,
			fbcolor;
	vec3	fnormal;
	vec2	fspec,
			ffresnel;
			
	fdcolor=texture2D(dif0,texcoord.st*dscale0+dofs0)*dcolor0;
	float alpha=texture2D(dif0,alphacoord.st).a*fadeAlpha;//alphalevel*colorMod.a;

	#ifdef MACROBUMP
		
		vec4 baseNormal=texture2D(bmp0,texcoord.st*bscale0+bofs0);
		fnormal=vec3(0,0,0);
//		fspec.x=0.0;
		ffresnel.y=pow(fresnel0.y,baseNormal.a);
		
	#else

		fbcolor=texture2D(bmp0,texcoord.st*bscale0+bofs0);
		fnormal=(fbcolor.xyz*2.0-1.0);
//		fspec.x=spec0.x;
		ffresnel.y=pow(fresnel0.y,fbcolor.a);

	#endif

	#ifdef LAYER1

		vec3 	mask=texture2D(lmask,texcoord.st).rgb,
				compMask=vec3(1.0,1.0,1.0)-mask;
			
		fdcolor=texture2D(dif1,texcoord.st*dscale1+dofs1)*dcolor1*mask.r + (compMask.r)*fdcolor;	
		fbcolor=texture2D(bmp1,texcoord.st*bscale1+bofs1);
		fnormal=(fbcolor.xyz*2.0-1.0)*mask.r + (compMask.r)*fnormal;
//		fspec.x=spec1.x*mask.r + (compMask.r)*fspec.x;
		ffresnel.y=pow(fresnel1.y,fbcolor.a)*mask.r + (compMask.r)*ffresnel.y;
		
		#ifdef LAYER2
		
			fdcolor=texture2D(dif2,texcoord.st*dscale2+dofs2)*dcolor2*mask.g + (compMask.g)*fdcolor;	
			fbcolor=texture2D(bmp2,texcoord.st*bscale2+bofs2);
			fnormal=(fbcolor.xyz*2.0-1.0)*mask.g + (compMask.g)*fnormal;
//			fspec.x=spec2.x*mask.g + (compMask.g)*fspec.x;
			ffresnel.y=pow(fresnel2.y,fbcolor.a)*mask.g + (compMask.g)*ffresnel.y;
			
			#ifdef LAYER3
			
				fdcolor=texture2D(dif3,texcoord.st*dscale3+dofs3)*dcolor3*mask.b + (compMask.b)*fdcolor;	
				fbcolor=texture2D(bmp3,texcoord.st*bscale3+bofs3);
				fnormal=(fbcolor.xyz*2.0-1.0)*mask.b + (compMask.b)*fnormal;
//				fspec.x=spec3.x*mask.b + (compMask.b)*fspec.x;
				ffresnel.y=pow(fresnel3.y,fbcolor.a)*mask.b + (compMask.b)*ffresnel.y;
				
			#endif

		#endif

	#endif

	#ifdef MACROBUMP

//		fspec.x+=spec0.x;
		fnormal.z=0.0;
		fnormal=(baseNormal.xyz*2.0-1.0)+fnormal;
		
	#endif
	
	normalize(fnormal);
	fdcolor.a=alpha;
	gl_FragData[0]=max(fdcolor,0.0);
	
	// normal
	gl_FragData[1].xy=encode(TBN*fnormal);
	gl_FragData[1].a=fdcolor.a;//*alphalevel;
		
	// material params
	gl_FragData[2].r=0.0;//(floor(glossPow)*32.0 + floor(fspec.y));//fspec.x;
	gl_FragData[2].g=ffresnel.y*0.00390625;//fspec.y;
	gl_FragData[2].b=0.0;
	gl_FragData[2].a=fdcolor.a;//0.0;//*alphalevel;
}
